#include <AT91SAM7X256.h>
#include <lib_AT91SAM7X256.h>
#include <rtl.h>

__task void task_init(void);
__task void task_led1(void);
__task void task_led2(void);
__task void task_led3(void);
__task void task_led4(void);
__task void task_button1(void);
__task void task_button2(void);

OS_TID tsk1,tsk2;


int main()
{
   
   os_sys_init(task_init);

   while(1){}
   return 0;
}

__task void task_init(void)
{
	// Initialize Outputs on PORTB 
   *AT91C_PIOB_PER = 0x0F;
   *AT91C_PIOB_OER = 0x0F;
   *AT91C_PIOB_OWER = 0x0F;
	// Initialize Inputs on PORTA 
   *AT91C_PMC_PCER= 1 << AT91C_ID_PIOA;
   *AT91C_PIOA_ODR = 0x03;
   *AT91C_PIOA_PPUER = 0x03;
   *AT91C_PIOA_PER = 0x03;
   // Cerate Tasks
   os_tsk_create(task_led1, 2);
   os_tsk_create(task_led2, 2);
   tsk1 = os_tsk_create(task_led3, 1);
   tsk2 = os_tsk_create(task_led4, 1);
   os_tsk_create(task_button1, 1);
   os_tsk_create(task_button2, 1);
	// Delete init_task
   os_tsk_delete_self();
}   

__task void task_led1(void)
{
   os_itv_set(100);
   while(1){
	  os_itv_wait();
      *AT91C_PIOB_ODSR ^= (1 << 0);   
   }
}

__task void task_led2(void)
{
   os_itv_set(200);
   while(1){
   		os_itv_wait();
      	*AT91C_PIOB_ODSR ^= (1 << 1);  
   }
}

__task void task_led3(void)
{
   while(1){
	  os_evt_wait_or(0x03,0xFFFF); 
      if (os_evt_get()&1) *AT91C_PIOB_SODR = (1 << 2);
	  else if (os_evt_get()&2) *AT91C_PIOB_CODR = (1 << 2);   
   }
}

__task void task_led4(void)
{
   while(1){
	  os_evt_wait_or(0x03,0xFFFF);
	   
      if (os_evt_get()&1)  *AT91C_PIOB_SODR = (1 << 3);
	  else if (os_evt_get()&2) *AT91C_PIOB_CODR = (1 << 3);   	   
   }
}

__task void task_button1(void)
{
   while(1){
      	while ((*AT91C_PIOA_PDSR&1)==1) os_dly_wait(5);
		os_evt_set(0x01,tsk1);
		while ((*AT91C_PIOA_PDSR&1)==0) os_dly_wait(5);
		os_evt_set(0x02,tsk1); 
   }
}

 __task void task_button2(void)
{
   while(1){
      	while ((*AT91C_PIOA_PDSR&2)==2) os_dly_wait(5);
		os_evt_set(0x01,tsk2);
		while ((*AT91C_PIOA_PDSR&2)==0) os_dly_wait(5);
		os_evt_set(0x02,tsk2); 
   }
}
